<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.app.controller;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import ${pub.getPKGCodeName()}.ibizutil.domain.ActionResult;
import ${pub.getPKGCodeName()}.ibizutil.errors.BadRequestAlertException;
import org.springframework.validation.annotation.Validated;
import org.springframework.http.ResponseEntity;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;

@RestController
public class AppMenuController{

<#list pub.getPSSystem().getAllPSApps() as app>
	<#assign appName=app.getPKGCodeName()?lower_case>
	<#if app.getAllPSAppMenuModels?? &&  app.getAllPSAppMenuModels()??>
		<#list app.getAllPSAppMenuModels() as item>
	<#assign appReqUrl="/"+app.getPKGCodeName()?lower_case+"/ctrl/"+item.codeName?lower_case+"appmenu">
	@GetMapping(value="${appReqUrl}/get")
	public ResponseEntity<JsonNode> ${appName}${item.codeName?lower_case?cap_first}Get(){
		JsonNode jsonNode;
		try{
			InputStream in = this.getClass().getResourceAsStream("/appmenu/${app.getPKGCodeName()?lower_case}_${item.codeName?lower_case}.json");
        	jsonNode = new ObjectMapper().readTree(in);
		}
		catch(Exception ex){
			 throw new BadRequestAlertException("操作发生错误","","");
		}
		return ResponseEntity.ok().body(jsonNode);
	}
	<#if item.getPSSysCounter?? && item.getPSSysCounter()??>
	<#assign sysCounter=item.getPSSysCounter()>
	/**
	 * 菜单计数器
	 * @return
	 */
	@GetMapping(value="${appReqUrl}/get${sysCounter.codeName?lower_case}counter")
	public ResponseEntity<JSONObject> ${appName}Get${sysCounter.codeName?lower_case?cap_first}Counter(){
		JSONObject jobj=new JSONObject();
		return ResponseEntity.ok().body(jobj);
	}
	</#if>
		</#list>
	</#if>
	/**
	 * 系统预置服务接口
	 * @return
	 */
	@RequestMapping(value="/${app.getPKGCodeName()?lower_case}/app/${app.getPKGCodeName()?lower_case}/getappdata")
    public ResponseEntity<AppData> ${appName}GetAppData(@Validated HttpServletRequest request){
		AppData appData = new AppData();
    	return ResponseEntity.ok().body(appData);
    }
</#list>
	@Data
	static protected class AppData{
		private String remotetag = null;
		private ObjectNode localdata = null;
	}
}
